﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Excel;
using System.Data;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Product
{
    public partial class Products : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (WebSession.PageNumber == 0)
                    WebSession.PageNumber = 1;
                else
                    grdProducts.PageIndex = WebSession.PageNumber - 1;
                BindProductList(string.Empty);
                
            }
        }

        private void BindProductList(string searchWord)
        {
            List<Entities.Products> pcList = ProductsBL.GetList(Guid.Empty, searchWord);
            pcList = (from pb in pcList
                      where pb.IsActive
                      orderby pb.ProductName ascending
                      select pb).ToList<Entities.Products>();
            grdProducts.DataSource = pcList;//.OrderBy(reg => reg.SequenceNo);
            grdProducts.DataBind();

            if (pcList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product found");
        }

        protected void grdProducts_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProducts.PageIndex = e.NewPageIndex;
            WebSession.PageNumber = e.NewPageIndex + 1;
            BindProductList(txtSearch.Text.Trim());
        }

        protected void grdProducts_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblCategoryName = e.Row.FindControl("lblCategoryName") as Label;
                Label lblBrandName = e.Row.FindControl("lblBrandName") as Label;
                Label lblSizeName = e.Row.FindControl("lblSizeName") as Label;

                Entities.Products curProd = (Entities.Products)e.Row.DataItem;

                lblCategoryName.Text = ProductCategoryBL.GetItem(curProd.ProductCategoryID, string.Empty).CategoryName;
                lblBrandName.Text = ((curProd.ProductBrandID != null && curProd.ProductBrandID != Guid.Empty) ? ProductBrandBL.GetItem(curProd.ProductBrandID, string.Empty).BrandName : string.Empty);
                lblSizeName.Text = ((curProd.ProductMeasurementID != null && curProd.ProductMeasurementID != Guid.Empty) ? ProductMeasurementBL.GetItem(curProd.ProductMeasurementID, string.Empty).MeasurementName : string.Empty);
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductList(string.Empty);
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductList(string.Empty);
            Master.ExportToExcel<Entities.Products>(grdProducts, "ProductsReport");
        }



        public override void VerifyRenderingInServerForm(Control control)
        {
            /* Verifies that the control is rendered */
        }

        protected void btnUploadInventoryExcel_Click(object sender, EventArgs e)
        {
            lblError.Visible = false;
            string docName, rootPath, fullName;
            docName = rootPath = fullName = string.Empty;
            docName = uplInventoryExcel.FileName;
            rootPath = Server.MapPath("~/Images/ProductsImages/");
            fullName = WebUtilities.CreateFileWithUniqueName(rootPath, docName);
            uplInventoryExcel.SaveAs(fullName);

            var file = new FileInfo(fullName);
            using (var stream = new FileStream(fullName, FileMode.Open))
            {
                IExcelDataReader reader = null;
                if (file.Extension == ".xls")
                {
                    reader = ExcelReaderFactory.CreateBinaryReader(stream);

                }
                else if (file.Extension == ".xlsx")
                {
                    reader = ExcelReaderFactory.CreateOpenXmlReader(stream);
                }

                if (reader == null)
                    return;
                reader.IsFirstRowAsColumnNames = true;
                List<Entities.Products> AllProducts = ProductsBL.GetList(Guid.Empty, string.Empty);
                if (AllProducts != null && AllProducts.Count > 0)
                {
                    AllProducts = AllProducts.Where(a => a.IsActive).ToList<Entities.Products>();
                }
                List<Entities.ProductBrand> AllBrands = ProductBrandBL.GetList(Guid.Empty, string.Empty);
                if (AllBrands != null && AllBrands.Count > 0)
                {
                    AllBrands = AllBrands.Where(a => a.IsActive).ToList<Entities.ProductBrand>();
                }
                List<Entities.ProductMeasurement> AllSizes = ProductMeasurementBL.GetList(Guid.Empty, string.Empty);
                if (AllSizes != null && AllSizes.Count > 0)
                {
                    AllSizes = AllSizes.Where(a => a.IsActive).ToList<Entities.ProductMeasurement>();
                }
                List<Entities.Products> ProductCombinations = AllProducts;
                Entities.ProductBrand BrandCombination;
                Entities.ProductMeasurement SizeCombination;

                List<Entities.Products> FinalProducts = new List<Entities.Products>();
                Entities.Products CurProduct, ActualProduct;
                string Size, Brand;
                Size = Brand = string.Empty;
                //Skip the first row - Table Header
                reader.Read();
                while (reader.Read())
                {
                    try
                    {
                        CurProduct = new Entities.Products();
                        CurProduct.ProductName = reader.GetString(0);
                        Size = reader.GetString(1);
                        Brand = reader.GetString(2);
                        CurProduct.UnitPrice = reader.GetDecimal(3);
                        CurProduct.HappyHourPrice = reader.GetDecimal(4);
                        CurProduct.ActualStock = reader.GetInt32(5);
                        CurProduct.ReserveStock = reader.GetInt32(6);
                        CurProduct.LowStockIndication = reader.GetInt32(7);
                    }
                    catch
                    {
                        continue;
                    }
                    try
                    {
                        ProductCombinations = AllProducts.Where(a => a.ProductName == CurProduct.ProductName).ToList<Entities.Products>();
                        BrandCombination = AllBrands.Where(a => a.BrandName == Brand).Single<ProductBrand>();
                        SizeCombination = AllSizes.Where(a => a.MeasurementName == Size).Single<ProductMeasurement>();

                        ActualProduct = ProductCombinations.Where(a => a.ProductBrandID == BrandCombination.UniqueID && a.ProductMeasurementID == SizeCombination.UniqueID).Single();
                        ActualProduct.UnitPrice = CurProduct.UnitPrice;
                        ActualProduct.HappyHourPrice = CurProduct.HappyHourPrice;
                        ActualProduct.ActualStock = CurProduct.ActualStock;
                        ActualProduct.ReserveStock = CurProduct.ReserveStock;
                        ActualProduct.LowStockIndication = CurProduct.LowStockIndication;
                    }
                    catch
                    {
                        continue;
                    }
                    FinalProducts.Add(ActualProduct);
                }
                gvInventory.DataSource = FinalProducts;
                gvInventory.DataBind();
                WebUtilities.RegisterStartupScript(this, "OpenConfirmation();");

            }

            try
            {
                File.Delete(fullName);
            }
            catch
            {

            }
        }

        protected void btnConfirmUpdate_Click(object sender, EventArgs e)
        {
            List<Entities.Products> FinalProducts = new List<Entities.Products>();
            foreach (GridViewRow gvr in gvInventory.Rows)
            {
                try
                {
                    string strProductID = (gvr.FindControl("hdnProductID") as HiddenField).Value;

                    Guid ProductID = Guid.Parse(strProductID);
                    Entities.Products CurrProduct = ProductsBL.GetItem(ProductID, string.Empty);

                    decimal UnitPrice, HappyHourPrice;
                    UnitPrice = HappyHourPrice = 0.00M;
                    int ActualStock, ReserveStock, LowStock;
                    ActualStock = ReserveStock = LowStock = 0;

                    UnitPrice = Convert.ToDecimal((gvr.FindControl("txtUnitPrice") as TextBox).Text);
                    HappyHourPrice = Convert.ToDecimal((gvr.FindControl("txtHappyHourPrice") as TextBox).Text);
                    ActualStock = Convert.ToInt32((gvr.FindControl("txtActualStock") as TextBox).Text);
                    ReserveStock = Convert.ToInt32((gvr.FindControl("txtReserveStock") as TextBox).Text);
                    LowStock = Convert.ToInt32((gvr.FindControl("txtLowStockIndication") as TextBox).Text);

                    CurrProduct.UnitPrice = UnitPrice;
                    CurrProduct.HappyHourPrice = HappyHourPrice;
                    CurrProduct.ActualStock = ActualStock;
                    CurrProduct.ReserveStock = ReserveStock;
                    CurrProduct.LowStockIndication = LowStock;

                    FinalProducts.Add(CurrProduct);
                }
                catch
                {
                    lblError.Text = "Please check the values";
                    lblError.Visible = true;
                    WebUtilities.RegisterStartupScript(this, "OpenConfirmation();");
                    return;
                }
            }
            try
            {
                foreach (Entities.Products _Product in FinalProducts)
                {
                    ProductsBL.Save(_Product);
                }
                FinalProducts = ProductsBL.GetList(Guid.Empty, string.Empty).OrderBy(a => a.ProductName).ToList();
                if (FinalProducts != null && FinalProducts.Count > 0)
                {
                    FinalProducts = FinalProducts.Where(a => a.IsActive).ToList<Entities.Products>();
                }
                grdProducts.DataSource = FinalProducts;
                grdProducts.DataBind();
                WebUtilities.ShowMessage(this, "Inventory updated successfully!");
            }
            catch
            {
                lblError.Text = "Error while saving the Inventory. Please try again later.";
                lblError.Visible = true;
                WebUtilities.RegisterStartupScript(this, "OpenConfirmation();");
            }

        }

        protected void gvInventory_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Guid ProductID = Guid.Parse((e.Row.FindControl("hdnProductID") as HiddenField).Value);
                Entities.Products CurProduct = ProductsBL.GetItem(ProductID, string.Empty);
                Label Size = e.Row.FindControl("lblProductSize") as Label;
                Size.Text = ProductMeasurementBL.GetList(Guid.Empty, string.Empty).Where(a => a.UniqueID == CurProduct.ProductMeasurementID).Select(a => a.MeasurementName).Single();
                Label Brand = e.Row.FindControl("lblProductBrand") as Label;
                Brand.Text = ProductBrandBL.GetList(Guid.Empty, string.Empty).Where(a => a.UniqueID == CurProduct.ProductBrandID).Select(a => a.BrandName).Single();
            }
        }

    }
}